IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_DENEGADA]') AND type in (N'U'))
begin
CREATE TABLE [dbo].[EST_NF_ENT_DENEGADA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[DT_DENEGADA] [datetime] NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_NF_ENT_DENEGADA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_NF_ENT_DENEGADA] ADD  CONSTRAINT [DF_EST_NF_ENT_DENEGADA_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_NF_ENT_DENEGADA]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_DENEGADA_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_ENT_DENEGADA] CHECK CONSTRAINT [FK_EST_NF_ENT_DENEGADA_EST_NF_ENT]
end

